/**
 * ValidationError.js
 *
 * Company: Hyfinity Ltd
 * Copyright (c) 2003 
 *
 * Class to store details of a field that has failed a validation test
 *
 * @author Gerard Smyth 
 * @version 1.0
 *
 */

 
function ValidationError(field, errorCode)
{
    this._field = field;
    this._errorCode = errorCode;
    
    //initalize the 'static' error code variables
    ValidationError.ERROR_INVALID_TYPE = 1;
    ValidationError.ERROR_REQUIRED = 2;
    ValidationError.ERROR_NAN = 3;
    ValidationError.ERROR_INVALID_DATE = 4;
    ValidationError.ERROR_MAX_INCLUSIVE = 5;
    ValidationError.ERROR_MAX_EXCLUSIVE = 6;
    ValidationError.ERROR_MIN_INCLUSIVE = 7;
    ValidationError.ERROR_MIN_EXCLUSIVE = 8;
    ValidationError.ERROR_REGULAR_EXPRESSION = 9;
    ValidationError.ERROR_LENGTH = 10;
    ValidationError.ERROR_MIN_LENGTH = 11;
    ValidationError.ERROR_MAX_LENGTH = 12;
    ValidationError.ERROR_NOT_VALID_BOOLEAN = 13;
   
    
    // Initialize the member function references 
    // for the class prototype
    if (typeof(_ValidationErrorPrototypeCalled) == 'undefined') 
    {
        _ValidationErrorPrototypeCalled = true;
        ValidationError.prototype.getField = getField;
        ValidationError.prototype.getErrorCode = getErrorCode;        
    }
    
    
    /**
     * get the HTML field that has failed the test
     *
     * @return the field associated with this object
     */
    function getField()
    {
        return this._field;   
    }
     
     
    /**
     * get the code of the test that this field has failed
     *
     * @return the failed test error code
     */
    function getErrorCode()
    {
        return this._errorCode;   
    }
     
     
    
    
}
