/*
 * DisplayUitls.js
 *
 * Utility functions for altering the display of HTML componenets from javascript
 *
 * Company: Hyfinity Ltd
 * Copyright (c) 2003
 */


/**
 * Generic function for toggling the display of a component.
 * @param componentID the ID of the HTML component to show/hide
 * @param method An optional string specifying the required visibility of the
 *               component ('show' or 'hide')
 */
function toggleComponent(componentID, method)
{
    var component = document.getElementById(componentID);
    if ((component != null) && (typeof(component) != 'undefined'))
    {
        if (typeof(method) == 'undefined')
        {
            if (getCurrentStyle(component, 'display') == 'none')
            {
                showComponent(component);
            }
            else
            {
                hideComponent(component);
            }
        }
        else
        {
            if (method == 'hide')
            {
                hideComponent(component);
            }
            else
            {
                showComponent(component);
            }
        }
    }
}

/*generic utility function for hiding a specific component*/
function hideComponent(component)
{
    if (component == null)
        return;

    if (component._oldCSSDisplay == undefined)
        component._oldCSSDisplay = getCurrentStyle(component, 'display');

    component.style.visibility = 'hidden';
    component.style.display = 'none';
}
/*generic utility function for showing a particular component*/
function showComponent(component)
{
    if (component == null)
        return;

    component.style.visibility = 'visible';
    if (component._oldCSSDisplay != undefined)
        component.style.display= component._oldCSSDisplay;
    else
        component.style.display = 'block';
}

/* utility function for disabling a component
 * may want to extend this so children components are disabled as well, ie if a div component is passed in*/
function disableComponent(component)
{
    if (component == null)
        return;

    component.disabled=true;
}

/* utility function for enabling a component*/
function enableComponent(component)
{
    if (component == null)
        return;

    component.disabled=false;
}

/**
 * Returns the current value for the given style property on the given object
 */
function getCurrentStyle(object, property)
{
    var currentDisplay;
    if (object.currentStyle)
        currentDisplay = object.currentStyle[property];
    else if (window.getComputedStyle)
        currentDisplay = document.defaultView.getComputedStyle(object,null).getPropertyValue(property);
    return currentDisplay;
}

/**
 * Restricts the vertical size of the specified table so that only the given number of rows are displayed
 * at one time, and adds scrollbars to see all the data.
 * @param row The DOM object for a row in the table
 * @param container The DOM object for the DIV containing the table (and nothing else)
 * @param body The DOM object representing the TBODY elemnt of the table.
 * @param headings The DOM object representing the heading row (TR) of the table.
 * @param numRows An integer value indicating the numebr of rows to display.
 */
function setTableScrolling(row, container, body, headings, numRows)
{
    if ((row == null) || (container == null) || (body == null) || (headings == null))
    {
        //required components of the table are not present, so return
        return;
    }
    var rowHeight = getComputedHeight(row);
    var headingsHeight = getComputedHeight(headings);
    if (is_ie)
    {
        container.style.overflow = 'auto';
        container.style.overflowY = 'scroll';
        container.style.height = ((rowHeight * numRows) + headingsHeight) + 'px';
        container.style.width = getComputedWidth(headings) + 20;
        headings.style.position = 'relative';
        headings.style.setExpression('top', "document.getElementById('" + container.getAttribute('id') +"').scrollTop - 2");
        headings.style.left = 0;
    }
    else
    {
        body.style.overflow = 'scroll';
        body.style.overflowX = 'hidden';
        body.style.height = (rowHeight * numRows) + 'px';
    }
}

/**
 * Returns the current height of the given source component
 * @param source The DOM component to return the current computed height for
 * @return a float containing the current height value (pixels)
 */
function getComputedHeight(source)
{
    var compHeight
    if (is_ie)
    {
        compHeight = source.offsetHeight;
    }
    else
    {
        compHeight = document.defaultView.getComputedStyle(source, "").getPropertyValue("height");
    }
    return parseFloat(compHeight);
}

/**
 * Returns the current width of the given source component
 * @param source The DOM component to return the current computed width for
 * @return a float containing the current width value (pixels)
 */
function getComputedWidth(source)
{
    var compWidth
    if (is_ie)
    {
        compWidth = source.offsetWidth;
    }
    else
    {
        compWidth = document.defaultView.getComputedStyle(source, "").getPropertyValue("width");
    }
    return parseFloat(compWidth);
}




/* Functions for adjustable dividers. */
var dividerMode = 'stop'

var widthAdjustTarget;
var fixedPoint;
var directionMode;

function dividerPressed(target, mode)
{
    if (typeof(mode) == 'undefined')
    {
        mode = 'left';
    }

    dividerMode = 'move';
    widthAdjustTarget = target;
    directionMode = mode;
    if (directionMode == 'left')
    {
        fixedPoint = getLeftPosition(widthAdjustTarget);
    }
    else
    {
        fixedPoint = getRightPosition(widthAdjustTarget);
    }

    //alert(windowWidth);
}

function dividerMove(e)
{
    //alert(dividerMode);
    if (dividerMode == 'move')
    {
        var posx = 0;
        var posy = 0;
        var evt;
        var target;
        if (!e)
        {
            evt = window.event;
            target = evt.srcElement;
        }
        else //netscape
        {
            evt = e;
            target = evt.currentTarget;
        }

        //get the mouse coords
        if (evt.pageX || evt.pageY)
        {
            posx = evt.pageX;
            posy = evt.pageY;
        }
        else if (evt.clientX || evt.clientY)
        {
            posx = evt.clientX + document.body.scrollLeft;
            posy = evt.clientY + document.body.scrollTop;
        }

        var newWidth

        if (directionMode == 'left')
        {
            newWidth = posx - fixedPoint;
        }
        else
        {
            newWidth = fixedPoint - posx;
        }
        if (newWidth > 0)
        {
            widthAdjustTarget.style.width = newWidth;
        }
    }

}

function dividerReleased()
{
    dividerMode = 'stop';
}

function getLeftPosition(obj)
{
    var ol=obj.offsetLeft;
    while ((obj=obj.offsetParent) != null)
    {
        ol += obj.offsetLeft;
    }
    return ol;
}

function getRightPosition(obj)
{
    return getLeftPosition(obj) + obj.offsetWidth;
}

/*
*	Function that is used when there is a dropdown date format used in conjunction with a pop-up calendar script
*/
function setDropdownDateValuesGeneric(y,m,d,id)
{
    missCounter = 0;
    partCounter = 1;
    while(missCounter<2)
    {
        var currentField = document.getElementById(id+"_datefield_part_"+partCounter);
        if(currentField == null)
        {
            missCounter++;
        }
        else
        {
            if
            (
                (
                    currentField.getAttribute('_display_date_format')=="M"
                    || currentField.getAttribute('_display_date_format')=="MM"
                    || currentField.getAttribute('_display_date_format')=="MMM"
                    || currentField.getAttribute('_display_date_format')=="MMMM"
                )
                &&
                (
                    currentField.type == "select-one"
                )
            )
            {
                    currentField.selectedIndex=m;
            }
            else if
            (
                (
                    currentField.getAttribute('_display_date_format')=="d"
                    || currentField.getAttribute('_display_date_format')=="dd"
                )
                &&
                (
                    currentField.type == "select-one"
                )
            )
            {
                currentField.selectedIndex=d;
            }
            else
            {
                convertedValue = convertDate(y+"-"+m+"-"+d,"y-M-d",currentField.getAttribute('_display_date_format'));
                currentField.value=convertedValue;
            }
            missCounter = 0;
        }
        partCounter++;
    }
}





if (typeof(dojo) != 'undefined')
{
	// ash_change
	//dojo.require("dojo.event");
    //dojo.require("dojo.io");
    dojo.require("dojo.string");
	dojo.require("dojo.parser");
}


/**
 * Root object to contain all hyfinity functions.
 * This should remove the chance of a name conflict with other functionality.
 *
 * TODO: At some point we need to update all existing functionality to use this namespace.
 */
var hyf =
{
    version : '1.0'
};

/**
 * Attached the specified function to be called when the specified event occurs on the given object.
 * This removes the need to worry about browser complexities from the main code.
 * For now we delegate to dojo to handle this for us if possible.
 *
 * @param object The object to attach the event to
 * @param event a string specifiying the actual event that the fucntion should be called for eg 'onclick'
 * @param func The function that should be called when this event occurs.
 */
hyf.attachEventHandler = function(object, event, func)
{
    //use dojo to attach the event.
    if (typeof(dojo) != 'undefined')
		//dojo.event.connect(object, event, func); ash_change
        dojo.connect(object, event, func);
    else
        object.attachEvent(event, func);
};

/**
 * Main function used to handle any sub section submission functionality.
 * This is used to update part of the page by making an asynchronous call to the server for more data.
 *
 * @param URL The URL to call to retrieve the new inforamtion.
 * @param target The ID of the container in which to place the resulting HTML retrieved.
 * @param source (optional) The ID of a source container.  The contents of any input fields within this container
 *                  will be sent in the request to the remote service.
 *                  If this parameter is not present, the full details on the page will be submitted.
 * @param functionPrefix (optional) A string containing the prefix that will be used for all custom functions
 *                  related to this sub section submission.  The process will check for the presense of
 *                  three different functions that will be called if they exist:
 *                      <functionPrefix>ConfigureRequestParameters(requestParams)
 *                      <functionPrefix>SetLoadingMessage(message)
 *                      <functionPrefix>ManipulateResponse(response, successful)
 * @param validate (optional) A boolean field to indicate whether or not the data being submitted should be
 *                  first validated for compliance with the defined constraints.
 *                  If not provided, no validation will be performed.
 * @return A boolean value indicating whether or not the asynchronous call has been initiated.
 */
hyf.subSectionSubmit = function(URL, target, source, functionPrefix, validate)
{
    if (typeof(dojo) == 'undefined')
    {
        alert('This functionality requires the dojo framework to be available');
        return false;
    }

    //check if we need to validate the data being sent
    if (validate)
    {
        //check the formValidator objects have been defined
        if (typeof(formValidator) == 'undefined')
            createFormValidator();
        if (typeof(errorDisplay) == 'undefined')
            createErrorDisplay();

        // clear any currently highlighted errors
        errorDisplay.resetDisplay();

        var errors;
        //check if we need to validate a group or the whole page
        if ((typeof(source) == 'undefined') || document.getElementById(source) == null)
        {
            errors = formValidator.checkForm();
        }
        else
        {
            errors = formValidator.checkContainer(document.getElementById(source));
        }

        //show any errors found and return
        if (errors.length != 0)
        {
            errorDisplay.showErrors(errors);
            return false;
        }

    }

    var content;

    if ((typeof(source) == 'undefined') || document.getElementById(source) == null)
    {
        //TODO: how do we determine the form to send??
        //content = dojo.io.encodeForm(document.forms[0]); ash_change
		content = dojo.formToObject(document.forms[0]);
    }
    else
    {
        content = hyf.encodeContainer(document.getElementById(source));
    }
	
    var requestArgs = {
            url         :   URL,
            //postContent :   content,
			content		: 	content,
            mimetype    :   "text/html",
			handleAs	: 	"text"
            //method      :   "post"
            };

    //Add a hook for manipulation of the request args
    if (eval("window." + functionPrefix + 'ConfigureRequestParameters'))
        eval(functionPrefix + 'ConfigureRequestParameters(requestArgs)');

    requestArgs.handle = hyf.subSectionHandler;
    requestArgs.hyfTarget = target;
    requestArgs.hyfFunctionPrefix = functionPrefix;

    /*//if it is a absolute URL use the IFrameTransport to try and solve cross domain problems
    if (URL.toLowerCase().indexOf('http') == 0)
        requestArgs.transport = "IframeTransport";
    else
        requestArgs.transport = "XMLHTTPTransport";*/

    //Display a loading message in the target container
    var loadingContent = "Loading...";
    //check if the user has created a function to override this message
    if (eval("window." + functionPrefix + 'SetLoadingMessage'))
        eval('loadingContent = ' + functionPrefix + 'SetLoadingMessage(loadingContent)');

    //if the message is empty, don't change the display
    if (loadingContent != null)
		
        hyf.insertContent(document.getElementById(target), loadingContent);

	// dojo.io.bind(requestArgs); ash_change
    dojo.xhrPost(requestArgs);

    return true;
};

/**
 * Function to insert HTML content into the specified target container.
 * This also provides the option to evaluate any scripts present in the content
 *
 * @param target The HTML container into which the content will be inserted.
 *               Any existing content in this container will be lost.
 * @param content A string containing the HTML fragment to insert.
 * @param evalScripts an optional boolean flag to indicate whether scripts in the content should be evaluated
 *                  These will be evalauted only if true.
 * @private
 */
hyf.insertContent = function(target, content, evalScripts)
{
	
    scriptRegExp = '(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)';

    //seperate out any script tags from the content passed in.
    var match = new RegExp(scriptRegExp, 'img');
    var pureHTML = content.replace(match, '');
    var scripts  = content.match(match);

    //insert the HTML into the targte location
    target.innerHTML = pureHTML;
    //check for any dojo widgets in the inserted HTML
    //dojo.widget.createWidget(target); ash_change
	
    //check if the script fragments that we have stripped out need to be evaluated
    if (evalScripts && scripts != null)
    {
        match = new RegExp(scriptRegExp, 'im');
        setTimeout(function() {
            //long variable name to try and avoid conflicts with the scripts being executed.
            var script_counter_unique_name = 0;
            for (var script_counter_unique_name = 0; script_counter_unique_name < scripts.length; script_counter_unique_name++)
            {
                try
                {
                    //use the regex again (without the global flag) to remove the actual surrounding script tags
                    var scriptFragment = scripts[script_counter_unique_name].match(match)[1];
                    //check to see if the fragment contains a function definition which needs to
                    //be properly registered with this window
                    if (scriptFragment.indexOf('function ') != -1)
                    {
                        var functionStart = scriptFragment.indexOf('function ') + 9;
                        var functionEnd = scriptFragment.indexOf('(', functionStart);
                        var functionName = scriptFragment.substring(functionStart, functionEnd);
                        scriptFragment += '; window.' + functionName + ' = ' + functionName + ';';
                    }
                    eval(scriptFragment);
                }
                catch(e)
                {
                    //ignore
                }
            }
			dojo.parser.parse(target);
        }, 10);
    }
}

/**
 * Handler function called after each ajax call.
 * This is the method syntax required by dojo
 *
 * @param type A string indicating the results of the call ('load' or 'error' or ...)
 * @param data Either the text content retrieved from the server, or an error object
 * @param evt
 * @param req The request parameters array containing all the details used to inititate the request
 *
 * @private
 */
//hyf.subSectionHandler = function(type, data, evt, req)
hyf.subSectionHandler = function(response, ioArgs)
{
	
    var target = document.getElementById(ioArgs.args.hyfTarget);
	
	if(response instanceof Error)
	{
		//QUESTION: Do we want to pass either of the data or evt objects to the function?
        var content = "Unable to show details.  Please try again.";
        if (eval("window." + ioArgs.args.hyfFunctionPrefix + 'ManipulateResponse'))
            eval('content = ' + ioArgs.args.hyfFunctionPrefix + 'ManipulateResponse(content, false)');

        hyf.insertContent(target, content, true);
	}
	else
	{
		var content = response;
        //Add hook for manipulation of the response here (eg client side XSL)
        if (eval("window." + ioArgs.args.hyfFunctionPrefix + 'ManipulateResponse'))
            eval('content = ' + ioArgs.args.hyfFunctionPrefix + 'ManipulateResponse(content, true)');

        hyf.insertContent(target, content, true);
	}
	
    /*if (type == 'load')
    {
		alert();
        var content = data;
        //Add hook for manipulation of the response here (eg client side XSL)
        if (eval("window." + req.hyfFunctionPrefix + 'ManipulateResponse'))
            eval('content = ' + req.hyfFunctionPrefix + 'ManipulateResponse(content, true)');

        hyf.insertContent(target, content, true);
    }
    else if (type == 'error')
    {
		alert();
        //QUESTION: Do we want to pass either of the data or evt objects to the function?
        var content = "Unable to show details.  Please try again.";
        if (eval("window." + req.hyfFunctionPrefix + 'ManipulateResponse'))
            eval('content = ' + req.hyfFunctionPrefix + 'ManipulateResponse(content, false)');

        hyf.insertContent(target, content, true);
    }
    else
    {
		
        //TODO: what would cause us to get here, and how should it be handled?
        hyf.insertContent(target, data, true);
    }*/
};


/**
 * Creates a string containing the contents of all the input fields within the specified container
 *
 * @param cont The container DOM object to process.
 * @return The created string content in name=value format for submitting in a POST request.
 *
 * @private
 */
hyf.encodeContainer = function(cont)
{
    if (cont == null || typeof(cont) == 'undefined')
        return;

    var data = new Object();

    var inputs = cont.getElementsByTagName('input');

    //QUESTION: Is ASCII encoding the correct option?
    for (var i = 0; i < inputs.length; ++i)
    {
        //look at the type of input
        switch (inputs[i].type)
        {
            case 'file'     :   //cant handle this via ajax so just ignore
                                break;
            case 'radio'    :
            case 'checkbox' :   if (inputs[i].checked)
                                {
                                    //data.push(dojo.string.encodeAscii(inputs[i].name) + "=" + dojo.string.encodeAscii(inputs[i].value));
									data[inputs[i].name] = inputs[i].value;
                                }
                                break;
            //QUESTION: How should we handle these types?  Should they be submitted?
            case 'image'    :   break;
            case 'button'   :   break;
            case 'reset'    :   break;
            case 'submit'   :   break;
            //default         :   data.push(dojo.string.encodeAscii(inputs[i].name) + "=" + dojo.string.encodeAscii(inputs[i].value));
			default         :   data[inputs[i].name] = inputs[i].value;

        }
    }

    inputs = cont.getElementsByTagName('textarea');
    for (var i = 0; i < inputs.length; ++i)
    {
        //data.push(dojo.string.encodeAscii(inputs[i].name) + "=" + dojo.string.encodeAscii(inputs[i].value));
		data[inputs[i].name] = inputs[i].value;
    }

    inputs = cont.getElementsByTagName('select');
    for (var i = 0; i < inputs.length; ++i)
    {
        if (inputs[i].type == 'select-multiple')
        {
            for (var j = 0; j < inputs[i].options.length; ++j)
            {
                if (inputs[i].options[j].selected)
                {
                    //data.push(dojo.string.encodeAscii(inputs[i].name) + "=" + dojo.string.encodeAscii(inputs[i].options[j].value));
					data[inputs[i].name] = inputs[i].options[j].value;
                }
            }
        }
        else
        {
            //data.push(dojo.string.encodeAscii(inputs[i].name) + "=" + dojo.string.encodeAscii(inputs[i].value));
			data[inputs[i].name] = inputs[i].value;
        }
    }

    //need to add the language value as this wont be included in the encoded group
    for (var i = 0; i < document.forms.length; ++i)
    {
        if (typeof(document.forms[i].Language) != 'undefined')
        {
            data['Language'] = document.forms[0].Language.value;
            break;
        }
    }

    //return data.join('&') + '&';
	return data;
};

/**
 * The hyf.textarea namespace contains all functionality relating to textarea field controls.
 */
hyf.textarea =
{
    desc : "Handles functionality relating to textareas, eg auto expanding fields.",
    offsetBuffer : (is_ie) ? 2 : ((is_opera) ? 4 : 0)
};

/**
 * Handles automatically updating the size of the supplied textarea to support the current content.
 *
 * @param evt The (keypress) event object that triggered the call.
 * @param field The textarea object to adjust
 * @param min The minim number of rows to show in the textarea.
 * @param max The maximum number of rows to expand the textarea to.
 */
hyf.textarea.adjustHeight = function(evt, field, min, max)
{
    if ((evt != null) && (typeof(evt) != 'undefined'))
        var charCode = (evt.which) ? evt.which : event.keyCode;

    //ignore the arrow keys and shift/ctrl key
    if ((charCode >= 37 && charCode <= 40) || (charCode == 16) || (charCode == 17) || (evt && evt.ctrlKey))
    {
        return;
    }

    if ((max == null) || typeof(max) == 'undefined')
        max = Number.MAX_VALUE;
    if ((min == null) || typeof(min) == 'undefined')
        min = 1;


    //if the delete or backspace keys have been pressed then check whether to remove a row
    if ((field.rows > min) && ((charCode == 8) || (charCode == 46)))
    {
        if (is_ie)  //does this work for other browsers???
        {
            var needToAddBack = false;
            while ((field.rows >= min ) && (!hyf.textarea.hasScroll(field)))
            {
                field.rows--;
                needToAddBack = true;
            }
            if (needToAddBack)
                field.rows++;
        }
        else
        {
            //find a guess of the number of rows of text
            var numRows = hyf.textarea.countNumTextRows(field);

            //set based on this
            field.rows = (numRows < min) ? min : ((numRows <= max) ? numRows : max);
        }
    }
    //otherwise look at adding a row
    else if ((field.rows < max ) && (hyf.textarea.hasScroll(field)))
    {
        if (is_ie || is_gecko)
        {
            while ((field.rows < max ) && (hyf.textarea.hasScroll(field)))
            {
                field.rows++;
            }
        }
        else
        {
            //find a guess of the number of rows of text
            var numRows = hyf.textarea.countNumTextRows(field);

            //set based on this
            field.rows = (numRows < min) ? min : ((numRows <= max) ? numRows : max);
        }
    }
};

/**
 * Tries to determine whether the given textarea field currently has a scroll bar or not.
 * @param field The textarea object.
 * @return true or false depending on whether a scrollbar is currently required.
 *
 * @private
 */
hyf.textarea.hasScroll = function(field)
{
    //attempt to scroll to the bottom
    field.scrollTop = field.scrollHeight;
    //check if the field has been scrolled at all
    if (field.scrollTop != 0)
    {
        //field.value = content;
        return true;
    }
    else
    {
        //field.value = content;
        return false;
    }
}


/**
 * Returns an estimate of the number of rows used by the text content in the
 * provided textarea.
 * @param field The textarea object.
 *
 * @private
 */
hyf.textarea.countNumTextRows = function(field)
{
    //count number of line breaks
    var re = /\r\n|\r|\n/g;
    var numBreaks = 0;
    var lineStart = 0;
    while (re.exec(field.value))
    {
        numBreaks++;
        //for each line of text between physical breaks, try to work out how many lines it wraps to
        var newLineStart = re.lastIndex;
        var lineString = field.value.substring(lineStart, newLineStart);
        if (lineString.length > field.cols)
            numBreaks += Math.ceil(lineString.length / field.cols);

        lineStart = newLineStart;
    }

    var lineString = field.value.substring(lineStart);
    if (lineString.length == 0)
        return Number(numBreaks) + Number(1);
    else
        return Math.ceil(lineString.length / field.cols) + Number(numBreaks);

};