/*
 * DisplayMessages.js
 *
 * Company: Hyfinity Ltd
 * Copyright (c) 2003
 *
 * Class that generates display messages for a given error code
 * Will need to be replaced to create custom messages.
 *
 * @author Gerard Smyth
 * @version 1.0
 *
 */

function DisplayMessages()
{

}
    /**
     * get the message associated with the test that this field has failed
     * @param field The form object (input control, textarea, etc) that has failed the validation
     * @param errorCode The code number indicating the type of field - see validationError
     *
     * @return the failed test message
     */
    DisplayMessages.getMessage = function(field, errorCode)
    {
        switch (errorCode)
        {
            case ValidationError.ERROR_INVALID_TYPE : return "Type attribute is invalid.";
            case ValidationError.ERROR_REQUIRED : return "You must specify a value for this field.";
            case ValidationError.ERROR_NAN : return "This value must represent a valid number.";
            case ValidationError.ERROR_INVALID_DATE : if (field.getAttribute("_display_date_format") && (field.getAttribute("_error_data_format_display") != ''))
                                                      {
                                                          //alert("display format specified");
                                                          return "This value must be a valid date in the format "+field.getAttribute("_error_data_format_display")+".";
                                                      }
                                                      else
                                                      {
                                                          //alert("data format only");
                                                          return "This value must be a valid date in the format "+field.getAttribute("_data_date_format")+".";
                                                      }
            case ValidationError.ERROR_MAX_INCLUSIVE : return "This value cannot be greater than "+field.getAttribute("_maxInclusive")+".";
            case ValidationError.ERROR_MAX_EXCLUSIVE : return "This value must be less than "+field.getAttribute("_maxExclusive")+".";
            case ValidationError.ERROR_MIN_INCLUSIVE : return "This value cannot be less than "+field.getAttribute("_minInclusive")+".";
            case ValidationError.ERROR_MIN_EXCLUSIVE : return "This value must be greater than "+field.getAttribute("_minExclusive")+".";
            case ValidationError.ERROR_REGULAR_EXPRESSION : return "This value must match the regular expressions "+field.getAttribute("_regularExpression").split('*@*@*')+".";
            case ValidationError.ERROR_LENGTH : return "This value must be of length "+field.getAttribute("_length")+".";
            case ValidationError.ERROR_MIN_LENGTH : return "This value must have a minimum length of "+field.getAttribute("_minLength")+".";
            case ValidationError.ERROR_MAX_LENGTH : return "This value cannot have a length greater than "+field.getAttribute("_maxLength")+".";
            case ValidationError.ERROR_NOT_VALID_BOOLEAN : return "This field can only have a value of 'true' or 'false'.";
            default: return "This field is invalid.";
        }

    }




