/*
 * BooleanValidator.js
 *
 * Company: Hyfinity Ltd
 * Copyright (c) 2003 
 *
 * Wrapper object that contains a check method for validating a given field for conforming with the boolean type
 *
 * @author Gerard Smyth
 * @version 1.0
 *
 */
 

function BooleanValidator()
{
 
    // Initialize the member function references 
    // for the class prototype
    if (typeof(_BooleanValidatorPrototypeCalled) == 'undefined') 
    {
        _BooleanValidatorPrototypeCalled = true;
        BooleanValidator.prototype.check = checkField;        
    } 
    //alert("created boolean validator");
    
    
    /*
     * Main method that performs the validation check
     *
     * @return an array of ValidationError objects for the tests failed
     */
    function checkField(field)
    {
        var failedChecks = new Array();
        //alert("will check field "+field+" for boolean conformity here");
        switch (field.type)
        {            
            case "text":
            case "textarea":
            case "password":
            case "hidden":
                failedChecks = checkTextField(field);
                break;    
            case "select-one":
            case "select-multiple":
                failedChecks = checkSelectField(field);
                break;
            case "checkbox":
                failedChecks = checkCheckBoxField(field);
                break;
            case "radio":   
                failedChecks = checkRadioField(field);
                break;
            default:
                break;
        }
        return failedChecks;         
    }
    
    function checkTextField(field)
    {
        var failedChecks = new Array();
        
        //check if value required
        if (field.getAttribute("_required") == 'true')
        {
            if (field.value=='')
                failedChecks = failedChecks.concat(new ValidationError(field, ValidationError.ERROR_REQUIRED));                    
        }
        
        // Possibly should add checks for different boolean types, ie yes/no
        
        if ((field.value != '') && !((field.value == 'true') || (field.value == 'false')))
            failedChecks = failedChecks.concat(new ValidationError(field, ValidationError.ERROR_NOT_VALID_BOOLEAN));
                
        return failedChecks;
    }
    
    function checkSelectField(field)
    {
        var failedChecks = new Array();
        
        //check if value required and if so is one selected
        if (field.getAttribute("_required") == 'true')
        {             
            if (field.selectedIndex == -1)
               failedChecks = failedChecks.concat(new ValidationError(field, ValidationError.ERROR_REQUIRED));
           
            //May not want this to check text as well
            //eg, may have the text saying 'Please Select a Value'
            /*if (field.options[field.selectedIndex].value=='')
                checkVal = field.options[field.selectedIndex].text;
            else*/
                checkVal = field.options[field.selectedIndex].value;
             
            if (checkVal == '')
               failedChecks = failedChecks.concat(new ValidationError(field, ValidationError.ERROR_REQUIRED));
        }
        return failedChecks;
    }
    
    function checkCheckBoxField(field)
    {
        //Are any checks needed? - A Checkbox is already boolean, checked or not checked!
        return new Array();
    }
    
    function checkRadioField(field)
    {
        var failedChecks = new Array();
        
        var name = field.name;        
        var radioArray = eval("field.form."+name);                
        var checkVal = '';
        var checked = false;
        
        if (radioArray.length == undefined)
        {
            if (radioArray.checked == true)
            {
                checked = true;
                checkVal = radioArray.value;
            }
        }
        else
        {
            for (var i = 0; i < radioArray.length; ++i)
            {
                if (radioArray[i].checked == true)
                {
                    checked = true;
                    checkVal = radioArray[i].value;                
                }            
            }
        }
        
        //check if value required - ie one radio button must be selected
        if (field.getAttribute("_required") == 'true')
        {
            if (!checked)
                failedChecks = failedChecks.concat(new ValidationError(field, ValidationError.ERROR_REQUIRED));                    
        }
    }
    
    
}
