/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.QRCode;

public final class MaskUtil {
    private MaskUtil() {
    }

    public static int applyMaskPenaltyRule1(ByteMatrix matrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(matrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(matrix, false);
    }

    public static int applyMaskPenaltyRule2(ByteMatrix matrix) {
        int penalty = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y = 0; y < height - 1; ++y) {
            for (int x = 0; x < width - 1; ++x) {
                byte value = array[y][x];
                if (value != array[y][x + 1] || value != array[y + 1][x] || value != array[y + 1][x + 1]) continue;
                penalty += 3;
            }
        }
        return penalty;
    }

    public static int applyMaskPenaltyRule3(ByteMatrix matrix) {
        int penalty = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (x + 6 < width && array[y][x] == 1 && array[y][x + 1] == 0 && array[y][x + 2] == 1 && array[y][x + 3] == 1 && array[y][x + 4] == 1 && array[y][x + 5] == 0 && array[y][x + 6] == 1 && (x + 10 < width && array[y][x + 7] == 0 && array[y][x + 8] == 0 && array[y][x + 9] == 0 && array[y][x + 10] == 0 || x - 4 >= 0 && array[y][x - 1] == 0 && array[y][x - 2] == 0 && array[y][x - 3] == 0 && array[y][x - 4] == 0)) {
                    penalty += 40;
                }
                if (y + 6 >= height || array[y][x] != 1 || array[y + 1][x] != 0 || array[y + 2][x] != 1 || array[y + 3][x] != 1 || array[y + 4][x] != 1 || array[y + 5][x] != 0 || array[y + 6][x] != 1 || (y + 10 >= height || array[y + 7][x] != 0 || array[y + 8][x] != 0 || array[y + 9][x] != 0 || array[y + 10][x] != 0) && (y - 4 < 0 || array[y - 1][x] != 0 || array[y - 2][x] != 0 || array[y - 3][x] != 0 || array[y - 4][x] != 0)) continue;
                penalty += 40;
            }
        }
        return penalty;
    }

    public static int applyMaskPenaltyRule4(ByteMatrix matrix) {
        int numDarkCells = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (array[y][x] != 1) continue;
                ++numDarkCells;
            }
        }
        int numTotalCells = matrix.getHeight() * matrix.getWidth();
        double darkRatio = (double)numDarkCells / (double)numTotalCells;
        return Math.abs((int)(darkRatio * 100.0 - 50.0)) / 5 * 10;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getDataMaskBit(int maskPattern, int x, int y) {
        void var3_3;
        if (!QRCode.isValidMaskPattern(maskPattern)) {
            throw new IllegalArgumentException("Invalid mask pattern");
        }
        switch (maskPattern) {
            case 0: {
                int intermediate = y + x & 1;
                break;
            }
            case 1: {
                int intermediate = y & 1;
                break;
            }
            case 2: {
                int intermediate = x % 3;
                break;
            }
            case 3: {
                int intermediate = (y + x) % 3;
                break;
            }
            case 4: {
                int intermediate = (y >>> 1) + x / 3 & 1;
                break;
            }
            case 5: {
                int temp = y * x;
                int intermediate = (temp & 1) + temp % 3;
                break;
            }
            case 6: {
                int temp = y * x;
                int intermediate = (temp & 1) + temp % 3 & 1;
                break;
            }
            case 7: {
                int temp = y * x;
                int intermediate = temp % 3 + (y + x & 1) & 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + maskPattern);
            }
        }
        return var3_3 == false;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix matrix, boolean isHorizontal) {
        int penalty = 0;
        int numSameBitCells = 0;
        byte prevBit = -1;
        int iLimit = isHorizontal ? matrix.getHeight() : matrix.getWidth();
        int jLimit = isHorizontal ? matrix.getWidth() : matrix.getHeight();
        byte[][] array = matrix.getArray();
        for (int i = 0; i < iLimit; ++i) {
            for (int j = 0; j < jLimit; ++j) {
                byte bit;
                byte by = bit = isHorizontal ? array[i][j] : array[j][i];
                if (bit == prevBit) {
                    if (++numSameBitCells == 5) {
                        penalty += 3;
                        continue;
                    }
                    if (numSameBitCells <= 5) continue;
                    ++penalty;
                    continue;
                }
                numSameBitCells = 1;
                prevBit = bit;
            }
            numSameBitCells = 0;
        }
        return penalty;
    }
}

