/** ===================================================================================================
* WARNING – This file is part of the base implementation for WebMaker, so it should not be edited or changed for any project. 
* These files are replaced if a project is re-imported to the WebMaker Studio or migrated to a new version of the product. 
* For guidance on ‘How do I override or clone Hyfinity webapp files such as CSS & javascript?’, please read the following relevant FAQ entry: 
* http://www.hyfinity.net/faq/index.php?solution_id=1113
==================================================================================================== */

function BasicWIHActionClient()
{
	this.basicWIH = null;
	this.initBasicWIHActionObject = BasicWIHActionClient_initBasicWIHActionObject;
	this.doAction = BasicWIHActionClient_doAction;
	this.getBasicWIHActionObject = BasicWIHActionClient_getBasicWIHActionObject;
	
	this.setContinueOption = BasicWIHActionClient_setContinueOption;
	this.getContinueOption = BasicWIHActionClient_getContinueOption;
	this.setContinue = BasicWIHActionClient_setContinue;
	this.setStop = BasicWIHActionClient_setStop;
	this.setWait = BasicWIHActionClient_setWait;
	
	this.complete = BasicWIHActionClient_complete;
	this.save = BasicWIHActionClient_save;
	this.monitor = BasicWIHActionClient_monitor;
	this.comment = BasicWIHActionClient_comment;
	this.attach = BasicWIHActionClient_attach;
	this.edmsAttach = BasicWIHActionClient_edmsAttach;
	this.adHoc = BasicWIHActionClient_adHoc;
	this.exit = BasicWIHActionClient_exit;
	this.generalInfo = BasicWIHActionClient_generalInfo;
	this.selectNextUser = BasicWIHActionClient_selectNextUser;
	this.selectNextApplication = BasicWIHActionClient_selectNextApplication;

    BasicWIHActionClient_initBasicWIHActionObject();
}

function BasicWIHActionClient_initBasicWIHActionObject()
{
	{
		if(top.parent.WIH_action && top.parent.WIH_action.getBasicWIHActionObject)
		{
			this.basicWIH = top.parent.WIH_action.getBasicWIHActionObject();
		}else
        {
            //in case of a modal window mode, find WIH_action frame going up to parent frame
            var obj = parent;
            while(obj)
            {
                if (obj.frames && "undefined" != typeof(obj.frames) && top != obj)
                {
                    if("undefined" != typeof(obj.frames["WIH_action"]))
                    {
                        this.basicWIH = obj.frames["WIH_action"].getBasicWIHActionObject();
                        break;
                    }else
                    {
                        obj = obj.parent;
                    }
                }else
                {
                    break;
                }
            }
        }
    }
}

function BasicWIHActionClient_getBasicWIHActionObject()
{
	this.initBasicWIHActionObject();
	return this.basicWIH;
}

function BasicWIHActionClient_setContinueOption(option)
{
	this.initBasicWIHActionObject();
	return this.basicWIH.setContinueOption(option);
}

function BasicWIHActionClient_getContinueOption()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.getContinueOption();
}

function BasicWIHActionClient_setContinue()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.setContinue();
}

function BasicWIHActionClient_setStop()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.setStop();
}

function BasicWIHActionClient_setWait()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.setWait();
}

function BasicWIHActionClient_complete()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.complete();
}

function BasicWIHActionClient_save()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.save();
}

function BasicWIHActionClient_monitor()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.monitor();
}

function BasicWIHActionClient_comment()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.comment();
}

function BasicWIHActionClient_attach()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.attach();
}

function BasicWIHActionClient_edmsAttach()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.edmsAttach();
}

function BasicWIHActionClient_adHoc()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.adHoc();
}

function BasicWIHActionClient_exit()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.exit();
}

function BasicWIHActionClient_generalInfo()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.generalInfo();
}

function BasicWIHActionClient_selectNextUser()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.selectNextUser();
}

function BasicWIHActionClient_selectNextApplication()
{
	this.initBasicWIHActionObject();
	return this.basicWIH.selectNextApplication();
}

/**
 * Do action
 * @command: command
 * @param1 ~ param5: this is not mandatory. these are defined for the extension in the future
 */
function BasicWIHActionClient_doAction(command)
{
	var ret;

	if(command == this.basicWIH.ACTION_COMPLETE)ret = this.complete();
	else if(command == this.basicWIH.ACTION_SAVE) ret = this.save();
	else if(command == this.basicWIH.ACTION_MONITOR) ret = this.monitor();
	else if(command == this.basicWIH.ACTION_COMMENT) ret = this.comment();
	else if(command == this.basicWIH.ACTION_ATTACH) ret = this.attach();
	else if(command == this.basicWIH.ACTION_EDMSATTACH) ret = this.edmsAttach();
	else if(command == this.basicWIH.ACTION_ADHOC) ret = this.adHoc();
	else if(command == this.basicWIH.ACTION_EXIT) ret = this.exit();
	else if(command == this.basicWIH.ACTION_GENERALINFO) ret = this.generalInfo();
	else if(command == this.basicWIH.ACTION_SELECT_NEXT_USER) ret = this.selectNextUser();
	else if(command == this.basicWIH.ACTION_SELECT_NEXT_APPLICATION) ret = this.selectNextApplication();

	return ret;
}

//Global Object for BasicWIHActionClient
var basicWIHActionClient = new BasicWIHActionClient();