<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet exclude-result-prefixes="mvc trans" version="1.0" xmlns:mvc="http://www.hyfinity.com/mvc" xmlns:trans="http://www.hyfinity.com/translate" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output indent="yes" method="html" />
	<xsl:variable name="htmlContent" select="/mvc:eForm/*[local-name() != 'Control'][1]" />
	<xsl:variable name="pageName" select="substring-before(/mvc:eForm/mvc:Control/mvc:Page, '.xsl')" />
	<xsl:variable name="translationFile" select="document(concat('dictionary_', /mvc:eForm/mvc:Control/mvc:Language, '.xml'))" />
	<xsl:variable name="translationItems" select="$translationFile/trans:translations/*[local-name() = 'global' or @id = $pageName]" />
	<xsl:template match="/">
<!-- Check if we actually have any translations to do.
             If not then there is no point checking each field. -->
		<xsl:choose>
			<xsl:when test="count($translationItems/trans:translation_item) = 0">
<!--<xsl:copy-of select="$htmlContent" />-->
				<xsl:apply-templates mode="no_translations" select="$htmlContent" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="$htmlContent" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<!-- generic copy templates to handle the case where no translations exist.
         Unfortunately we cant just use xsl:copy-of as this copies across unwanted namespaces.-->
	<xsl:template match="*" mode="no_translations">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="@*" />
			<xsl:apply-templates mode="no_translations" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="text() | comment() | processing-instruction()" mode="no_translations">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="xform:instance" mode="no_translations" xmlns:xform="http://www.w3.org/2001/08/xforms">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="xform:xform" mode="no_translations" xmlns:xform="http://www.w3.org/2001/08/xforms">
		<xsl:copy>
			<xsl:copy-of select="@*" />
			<xsl:apply-templates mode="no_translations" />
		</xsl:copy>
	</xsl:template>
<!-- Match any container signifying the start of a repeat so that we can get the repeat ID
        NOTE: This is depenedant on the repeat class being applied to the container.  This is currently hard coded
        in the generation XSLs (HTMLGeneration.xsl) but if that changes then we will need to update this accordingly.-->
	<xsl:template match="*[@class = 'repeat']">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:apply-templates select="@*">
				<xsl:with-param name="currentRepeatID" select="@id" />
			</xsl:apply-templates>
			<xsl:apply-templates>
				<xsl:with-param name="currentRepeatID" select="@id" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
<!-- Match each TD displayed in the situations where a repeating table has no content
         This relies on the 'noRepeatData' class name which is currently defined in the HTMLGeneration.xsl process.-->
	<xsl:template match="td[@class = 'noRepeatData']">
		<xsl:param name="currentRepeatID" />
<!-- find the id of the repeat that this entry is for -->
		<xsl:variable name="elementName">
			<xsl:choose>
				<xsl:when test="contains(translate($currentRepeatID, '012345678', '999999999'), '9')">
					<xsl:call-template name="substring-after-last">
						<xsl:with-param name="string" select="translate($currentRepeatID, '012345678', '9999999999')" />
						<xsl:with-param name="seperator" select="'9'" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$currentRepeatID" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
<!-- Check if there is a translation for this empty repeat -->
		<xsl:choose>
			<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'repeat_no_data']">
				<xsl:element name="{name()}" namespace="{namespace-uri()}">
					<xsl:apply-templates select="@*">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
					</xsl:apply-templates>
<!-- check for dynamic values -->
					<xsl:choose>
						<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'repeat_no_data' and not(@dynamic_value)]">
							<xsl:value-of select="$translationItems/trans:translation_item[@id = $elementName]/trans:part[@type = 'repeat_no_data']/@value" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="currentValue" select="normalize-space(.)" />
							<xsl:choose>
								<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'repeat_no_data' and @dynamic_value = $currentValue]">
<!-- output the matched translation -->
									<xsl:value-of select="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'repeat_no_data' and @dynamic_value = $currentValue]/@value" />
								</xsl:when>
								<xsl:otherwise>
<!-- no match, so just output the value from the data -->
									<xsl:value-of select="$currentValue" />
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="{name()}" namespace="{namespace-uri()}">
					<xsl:apply-templates select="@*">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
					</xsl:apply-templates>
					<xsl:apply-templates select="node()">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<!-- Match all the possible HTML tags that could be used for labels -->
	<xsl:template match="label | th | span | legend | h2">
		<xsl:param name="currentRepeatID" />
<!-- Check if this is actually for a label (does id end '_label') -->
		<xsl:choose>
			<xsl:when test="substring(@id, string-length(@id) - 5) = '_label'">
				<xsl:variable name="elementName">
					<xsl:call-template name="find-component-id">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
						<xsl:with-param name="fieldID" select="substring(@id, 1, string-length(@id) - 6)" />
					</xsl:call-template>
				</xsl:variable>
<!-- check if we have a translation for this elements label -->
				<xsl:choose>
					<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'label']">
						<xsl:element name="{name()}" namespace="{namespace-uri()}">
							<xsl:apply-templates select="@*">
								<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
							</xsl:apply-templates>
							<xsl:for-each select="node()">
								<xsl:choose>
									<xsl:when test="self::text()">
<!-- check for dynamic values -->
										<xsl:choose>
											<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'label' and not(@dynamic_value)]">
												<xsl:value-of select="$translationItems/trans:translation_item[@id = $elementName]/trans:part[@type = 'label']/@value" />
											</xsl:when>
											<xsl:otherwise>
												<xsl:variable name="currentValue" select="normalize-space(.)" />
												<xsl:choose>
													<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'label' and @dynamic_value = $currentValue]">
<!-- output the matched translation -->
														<xsl:value-of select="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'label' and @dynamic_value = $currentValue]/@value" />
													</xsl:when>
													<xsl:otherwise>
<!-- no match, so just output the value form the data -->
														<xsl:value-of select="$currentValue" />
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select=".">
											<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
										</xsl:apply-templates>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
						</xsl:element>
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name="{name()}" namespace="{namespace-uri()}">
							<xsl:apply-templates select="@*">
								<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
							</xsl:apply-templates>
							<xsl:apply-templates select="node()">
								<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
							</xsl:apply-templates>
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
<!-- Not a label, so just copy across -->
				<xsl:element name="{name()}" namespace="{namespace-uri()}">
					<xsl:apply-templates select="@*">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
					</xsl:apply-templates>
					<xsl:apply-templates select="node()">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<!-- Match all the possible HTML tags that could be used for types of button to check for caption changes
        Also check spans as this should handle changing static output fields -->
	<xsl:template match="a | input[@type = 'button'] | span">
		<xsl:param name="currentRepeatID" />
<!-- Need to allow for the repeat info possiblly being at the start of each ID -->
		<xsl:variable name="elementName">
			<xsl:call-template name="find-component-id">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
				<xsl:with-param name="fieldID" select="@id" />
			</xsl:call-template>
		</xsl:variable>
<!-- check if we have a translation for this elements caption -->
		<xsl:choose>
			<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'caption']">
				<xsl:element name="{name()}" namespace="{namespace-uri()}">
					<xsl:apply-templates select="@*" />
<!-- check if a dynamic value has been specifed, or whether we should always use this value -->
					<xsl:choose>
						<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'caption' and not(@dynamic_value)]">
<!-- no dynamic value so always output the specified value -->
							<xsl:choose>
								<xsl:when test="local-name() = 'input'">
									<xsl:attribute name="value">
										<xsl:value-of select="$translationItems/trans:translation_item[@id = $elementName]/trans:part[@type = 'caption']/@value" />
									</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$translationItems/trans:translation_item[@id = $elementName]/trans:part[@type = 'caption']/@value" />
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
<!-- need to check dynamic values -->
							<xsl:variable name="currentValue">
								<xsl:choose>
									<xsl:when test="local-name() = 'input'">
										<xsl:value-of select="@value" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="text()" />
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
<!-- check if we have a dynamic value match -->
							<xsl:choose>
								<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'caption' and @dynamic_value = $currentValue]">
<!-- output the matched translation -->
									<xsl:choose>
										<xsl:when test="local-name() = 'input'">
											<xsl:attribute name="value">
												<xsl:value-of select="$translationItems/trans:translation_item[@id = $elementName]/trans:part[@type = 'caption' and @dynamic_value = $currentValue]/@value" />
											</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$translationItems/trans:translation_item[@id = $elementName]/trans:part[@type = 'caption' and @dynamic_value = $currentValue]/@value" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
<!-- no match, so just output the value form the data -->
									<xsl:apply-templates select="text()">
										<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
									</xsl:apply-templates>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:apply-templates select="*">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="{name()}" namespace="{namespace-uri()}">
					<xsl:apply-templates select="@*">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
					</xsl:apply-templates>
					<xsl:apply-templates select="node()">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
					</xsl:apply-templates>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<!-- Match title and alt attributes to look if the field tip strings need converting. -->
	<xsl:template match="@title | @alt">
		<xsl:param name="currentRepeatID" />
<!-- Need to allow for the repeat info possiblly being at the start of each ID -->
		<xsl:variable name="elementName">
			<xsl:call-template name="find-component-id">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
				<xsl:with-param name="fieldID" select="../@id" />
			</xsl:call-template>
		</xsl:variable>
<!-- check if we have a translation for this elements field tip -->
		<xsl:choose>
			<xsl:when test="$translationItems/trans:translation_item[@id = $elementName and @action = 'replace']/trans:part[@type = 'field_tip']">
				<xsl:attribute name="{name()}">
					<xsl:value-of select="$translationItems/trans:translation_item[@id = $elementName]/trans:part[@type = 'field_tip']/@value" />
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="." />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<!-- match select boxes to look at changing option values -->
	<xsl:template match="select">
		<xsl:param name="currentRepeatID" />
<!-- Need to allow for the repeat info possiblly being at the start of each ID -->
		<xsl:variable name="elementName">
			<xsl:call-template name="find-component-id">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
				<xsl:with-param name="fieldID" select="@id" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:apply-templates select="@*">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
			</xsl:apply-templates>
			<xsl:apply-templates select="node()">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
				<xsl:with-param name="optionTranslations" select="$translationItems/trans:translation_item[@id = $elementName]/trans:part[@type = 'select_option']" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="select/option">
		<xsl:param name="currentRepeatID" />
		<xsl:param name="optionTranslations" />
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:apply-templates select="@*">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
			</xsl:apply-templates>
			<xsl:choose>
				<xsl:when test="$optionTranslations[@dynamic_value = current()]">
					<xsl:value-of select="$optionTranslations[@dynamic_value = current()]/@value" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="node()">
						<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
					</xsl:apply-templates>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
<!-- Returns the actual ID to check in the dictionary file for the component with an id attribute of fieldID
         This checks to see if it starts with the given repeat ID, and if so removes this and the repeat entry number-->
	<xsl:template name="find-component-id">
		<xsl:param name="currentRepeatID" />
		<xsl:param name="fieldID" />
		<xsl:choose>
			<xsl:when test="$currentRepeatID != '' and starts-with($fieldID, $currentRepeatID)">
				<xsl:call-template name="remove-starting-numbers">
					<xsl:with-param name="string" select="substring-after($fieldID, $currentRepeatID)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$fieldID" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:variable name="digits">1234567890</xsl:variable>
<!-- removes any numbers from the start of the given string -->
	<xsl:template name="remove-starting-numbers">
		<xsl:param name="string" />
		<xsl:choose>
			<xsl:when test="contains($digits, substring($string, 1, 1))">
				<xsl:call-template name="remove-starting-numbers">
					<xsl:with-param name="string" select="substring($string, 2)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$string" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<!-- returns the contents of 'string' after the very last occurrence of
         the 'seperator' string. -->
	<xsl:template name="substring-after-last">
		<xsl:param name="string" />
		<xsl:param name="seperator" />
		<xsl:variable name="after" select="substring-after($string, $seperator)" />
		<xsl:choose>
			<xsl:when test="contains($after, $seperator)">
				<xsl:call-template name="substring-after-last">
					<xsl:with-param name="string" select="$after" />
					<xsl:with-param name="seperator" select="$seperator" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$after" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
<!-- Generic template that will match any node or attribute, and just copy it to the ouput -->
	<xsl:template match="*">
		<xsl:param name="currentRepeatID" />
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:apply-templates select="@*">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
			</xsl:apply-templates>
			<xsl:apply-templates select="node()">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="xform:instance" xmlns:xform="http://www.w3.org/2001/08/xforms">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="text() | comment() | processing-instruction() | @* | xform:xform" xmlns:xform="http://www.w3.org/2001/08/xforms">
		<xsl:param name="currentRepeatID" />
		<xsl:copy>
			<xsl:apply-templates select="@*">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
			</xsl:apply-templates>
			<xsl:apply-templates select="node()">
				<xsl:with-param name="currentRepeatID" select="$currentRepeatID" />
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
