<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet exclude-result-prefixes="mvc" version="1.0" xmlns="http://www.hyfinity.com/xstore" xmlns:mvc="http://www.hyfinity.com/mvc" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output encoding="ISO-8859-1" indent="yes" method="html" />
	<xsl:template match="/" name="demo_skin">
		<html lang="en" xml:lang="en" xmlns="">
			<head>
				<xsl:call-template name="head_html" />
			</head>
			<xsl:call-template name="body" />
		</html>
	</xsl:template>
	<xsl:template name="body">
		<body class="soria" xmlns="">
			<div id="page_content">
				<div class="tagline_bridge"></div>
				<div class="tagline"></div>
				<div class="banner">
					<span></span>
				</div>
				<xsl:call-template name="main_body" />
				<xsl:call-template name="logos" />
				<div id="tipDiv" style="position:absolute; top:-100px; left:-300px; width : 300px; height : 100px; visibility:hidden;">
					<iframe id="tipFrame" name="tipFrame" src="#" style="width :300px; height : 100px;" title="tipFrame">
						<xsl:text />
					</iframe>
					<div id="messageDiv" style="position: absolute; top : 0 ; left : 0; width : 100%; height : auto;">
						<xsl:text />
					</div>
				</div>
			</div>
		</body>
	</xsl:template>
	<xsl:template name="head_html">
		<title xmlns="">Visualise Orchestrate Integrate</title>
		<xsl:call-template name="css_imports" />
		<xsl:call-template name="global_css_imports" />
		<xsl:call-template name="global_meta_tags" />
		<xsl:call-template name="page_meta_tags" />
		<xsl:call-template name="global_scripts" />
		<xsl:call-template name="page_scripts" />
	</xsl:template>
	<xsl:template name="global_css_imports">
		<link href="js/dojo/dojo/resources/dojo.css" rel="stylesheet" type="text/css" xmlns="" />
		<link href="js/dojo/dijit/themes/tundra/tundra.css" rel="stylesheet" type="text/css" xmlns="" />
	</xsl:template>
	<xsl:template name="css_imports" />
	<xsl:template name="global_meta_tags">
		<meta content="text/xml; charset=UTF-8" http-equiv="Content-Type" xmlns="" />
		<meta content="text/css" http-equiv="Content-Style-Type" xmlns="" />
		<meta content="http://localhost:7080/Example" name="DC.identifier" scheme="URI" xmlns="" />
		<meta content="Hyfinity Corporate Web Site" lang="en" name="DC.title" xmlns="" />
		<meta content="FormMaker by Hyfinity Limited" lang="en" name="DC.creator" xmlns="" />
		<meta content="Hyfinity MVC demonstration application" name="DC.description" xmlns="" />
		<meta content="FormMaker by Hyfinity Limited - info@hyfinity.com" lang="en" name="DC.publisher" xmlns="" />
		<meta content="2005-03-14" name="DC.date.created" scheme="W3CDTF" xmlns="" />
		<meta content="2005-03-14" name="DC.date.modified" scheme="W3CDTF" xmlns="" />
		<meta content="text/html" name="DC.format" scheme="IMT" xmlns="" />
		<meta content="FormMaker by Hyfinity Limited" name="DC.contributor" xmlns="" />
		<meta content="Hyfinity Limited - http://www.hyfinity.com" name="DC.rights.copyright" xmlns="" />
		<meta content="FormMaker by Hyfinity Limited" http-equiv="Author" name="Author" xmlns="" />
		<meta content="index,follow" http-equiv="Robots" name="Robots" xmlns="" />
		<meta content="XML, SOA, Service Oriented Architecture, composite applications, xforms, xsd, transactional web sites, B2B integration" name="keywords" xmlns="" />
		<meta content="Hyfinity MVC demonstration application" name="description" xmlns="" />
		<meta content="noarchive" name="robots" xmlns="" />
		<meta content="true" name="MSSmartTagsPreventParsing" xmlns="" />
		<meta content="no" name="publication" xmlns="" />
	</xsl:template>
	<xsl:template name="page_meta_tags" />
	<xsl:template name="global_scripts">
		<script src="js/BrowserDetection.js" type="text/javascript" xmlns="">//import the browser detection script</script>
		<script type="text/javascript" xmlns="">
            djConfig={parseOnLoad: true};
        </script>
		<script src="js/dojo/dojo/dojo.js" type="text/javascript" xmlns="">//import dojo main script</script>
		<script src="js/DisplayUtils.js" type="text/javascript" xmlns="">//handles hide/display operations</script>
		<script src="js/FormValidator.js" type="text/javascript" xmlns="">//main entry point for validating a form</script>
		<script src="js/NumberValidator.js" type="text/javascript" xmlns="">//provides number validation</script>
		<script src="js/StringValidator.js" type="text/javascript" xmlns="">//provides string validation</script>
		<script src="js/BooleanValidator.js" type="text/javascript" xmlns="">//provides boolean validation</script>
		<script src="js/ValidationError.js" type="text/javascript" xmlns="">//represents a valiadtion error</script>
		<script src="js/ErrorDisplay.js" type="text/javascript" xmlns="">//shows validation errors on the form </script>
		<script src="js/DisplayMessages.js" type="text/javascript" xmlns="">//provides a list of display messages for each error</script>
		<script src="js/DateValidator.js" type="text/javascript" xmlns="">//provides date validation functions</script>
		<script src="js/FMActions.js" type="text/javascript" xmlns="">//provides implementations of the FM inbuilt actions</script>
		<script src="js/ValueConverter.js" type="text/javascript" xmlns="">//provides value conversion functions</script>
		<script src="js/combobox.js" type="text/javascript" xmlns="">//script required for editable combo box entries</script>
		<script src="js/date.js" type="text/javascript" xmlns="">//provides date manipulation functions</script>
		<script src="js/AnchorPosition.js" type="text/javascript" xmlns="">//determines the coordinates of an anchor</script>
		<script src="js/PopupWindow.js" type="text/javascript" xmlns="">//shows a popup window</script>
		<script src="js/CalendarPopup.js" type="text/javascript" xmlns="">//creates a calendar popup - needs the above two</script>
	</xsl:template>
	<xsl:template name="page_scripts" />
	<xsl:template name="logos">
		<div class="company_logo" xmlns=""></div>
	</xsl:template>
	<xsl:template name="main_menu" />
	<xsl:template name="context_menu" />
	<xsl:template name="main_body">
		<div class="main_body" xmlns="">
			<xsl:if test="/mvc:eForm/mvc:Control/error">
				<div class="messageBox">
					<xsl:for-each select="/mvc:eForm/mvc:Control/error">
						<xsl:value-of select="./@desc" />
						<br />
					</xsl:for-each>
				</div>
			</xsl:if>
			<xsl:call-template name="section_body" />
			<xsl:call-template name="footer" />
		</div>
	</xsl:template>
	<xsl:template name="section_title">
        This is a section title
    </xsl:template>
	<xsl:template name="section_body" />
	<xsl:template name="footer">
		<div class="footer">my footer</div>
	</xsl:template>
</xsl:stylesheet>
