/**
 * Node script for use with the WebMaker Studio to generate thumbnail images using Puppeteer.
 *
 * Author: Hyfinity Ltd
 * Copyright: 2021
 */

const puppeteer = require('puppeteer');

if (process.argv.length != 5) {
    console.log('Usage: node puppeteer_thumbnail_gen.js URL filename px_width');
    process.exit(1);
}

(async () => {
    const browser = await puppeteer.launch();
    const page = await browser.newPage();

    page.on('console', (msg) => console.log('PAGE LOG:', msg.text()));

    var pageWidth = parseInt(process.argv[4], 10);
    var pageHeight = parseInt(pageWidth * 3/4, 10);

    var address = process.argv[2];

    console.log('Generating image for ' + address);
    console.log("Rendering with width: " + pageWidth);
    console.log("Using initial height of: " + pageHeight);

    try
    {

        await page.setViewport({
            width: pageWidth,
            height: pageHeight
        });

        console.log("Loading page");

        await page.goto(address);

        let waitForPageReady = page.waitForFunction("(typeof pageReadyForThumbnail != 'undefined') && pageReadyForThumbnail", {timeout :5000});
        let scrollDownAndUp = async function() {

            //scroll down so that any show on scroll content is displayed
            await page.evaluate((_) => {
                window.scrollBy({
                    top: 50000,
                    behavior: "smooth",
                });
            });
            //give time for the scroll to happen
            await page.waitForTimeout(1000)
            // Scroll back to top
            await page.evaluate((_) => {
                window.scroll({
                    top: 0,
                    behavior: "auto",
                });
            });
        }();

        //can do both of the above in parallel so kick both off, and wait for promises to resolve now
        await scrollDownAndUp;
        try {
            await waitForPageReady;
        }
        catch (e) {
            //just continue on error here, as likely that the time limit was reached
            console.log('pageReadyForThumbnail timeout reached');
        }

        console.log('Generating image ', process.argv[3]);

        await page.screenshot({
            path: process.argv[3],
            fullPage: true
        });

        console.log('Done');

        await browser.close();
    }
    catch (e)
    {
        console.log("Error generating Image ", e);
        process.exit(1);
    }
})();
