/* ===================================================================================================
* WARNING – This file is part of the base implementation for WebMaker, so it should not be edited or changed for any project. 
* These files are replaced if a project is re-imported to the WebMaker Studio or migrated to a new version of the product. 
* For guidance on ‘How do I override or clone Hyfinity webapp files such as CSS & javascript?’, please read the following relevant FAQ entry: 
* http://www.hyfinity.net/faq/index.php?solution_id=1113
==================================================================================================== */

/* Functions for adjustable dividers. */
hyf.divider =
{
    dividerMode: 'stop',
    widthAdjustTarget: null,
    fixedPoint: null,
    directionMode: null,
    currentWidth: null,
    moveDivider: null
}

hyf.divider.dividerPressed = function(e, target, mode)
{
    if (typeof(mode) == 'undefined')
    {
        mode = 'left';
    }

    var evt;
    var evtTarget;
    if (window.event)
    {
        evt = window.event;
        evtTarget = evt.srcElement;
    }
    else //netscape
    {
        evt = e;
        evtTarget = evt.currentTarget;
    }

    hyf.divider.dividerMode = 'move';
    hyf.divider.widthAdjustTarget = target;
    hyf.divider.directionMode = mode;

    if (hyf.divider.directionMode == 'left')
    {
        hyf.divider.fixedPoint = hyf.util.getLeftPosition(hyf.divider.widthAdjustTarget);
        if (hyf.util.getCurrentStyle(hyf.divider.widthAdjustTarget, 'display') == 'none')
            hyf.divider.fixedPoint = hyf.util.getLeftPosition(evtTarget);
    }
    else
    {
        hyf.divider.fixedPoint = hyf.util.getRightPosition(hyf.divider.widthAdjustTarget);
        if (hyf.util.getCurrentStyle(hyf.divider.widthAdjustTarget, 'display') == 'none')
            hyf.divider.fixedPoint = hyf.util.getRightPosition(evtTarget);
    }

    hyf.divider.moveDivider = document.getElementById('temp_divider');
    if (hyf.divider.moveDivider == null)
    {
        hyf.divider.moveDivider = document.createElement('div');
        hyf.divider.moveDivider.setAttribute('id', 'temp_divider');
        hyf.divider.moveDivider.className = 'temp_divider';
        hyf.divider.moveDivider.onselectstart = new Function("return false;");
        document.body.appendChild(hyf.divider.moveDivider);
    }

    var targetPos = hyf.util.getComponentPosition(hyf.divider.widthAdjustTarget.parentNode);
    hyf.divider.moveDivider.style.top = targetPos.y + 'px';
    hyf.divider.moveDivider.style.height = targetPos.height + 'px';


    var pos = hyf.util.getMouseCoords(evt);

    hyf.divider.moveDivider.style.left = (pos.x - 5) + 'px';
    hyf.divider.moveDivider.style.display = 'block';

    if(evt.preventDefault){
        evt.preventDefault();
    }
    evt.cancelBubble=true;
    evt.returnValue = false;

}

hyf.divider.dividerMove = function(e, base)
{
    if (hyf.divider.dividerMode == 'move')
    {
        var pos = hyf.util.getMouseCoords(e, base);
        var evt;
        var target;
        if (window.event)
        {
            evt = window.event;
            target = evt.srcElement;
        }
        else //netscape
        {
            evt = e;
            target = evt.currentTarget;
        }

        if(evt.preventDefault){
            evt.preventDefault();
        }
        evt.cancelBubble=true;
        evt.returnValue = false;

        if (hyf.divider.directionMode == 'left')
        {
            hyf.divider.currentWidth = pos.x - hyf.divider.fixedPoint;
        }
        else
        {
            hyf.divider.currentWidth = hyf.divider.fixedPoint - pos.x;
        }

        hyf.divider.moveDivider.style.left = (pos.x - 5) + 'px';
    }

}

hyf.divider.dividerReleased = function()
{
    if (hyf.divider.dividerMode == 'move')
    {
        hyf.divider.dividerMode = 'stop';

        if (hyf.divider.currentWidth > 0)
        {
            hyf.divider.widthAdjustTarget.style.width = hyf.divider.currentWidth + 'px';
            hyf.util.hideComponent(hyf.divider.widthAdjustTarget);
            hyf.util.showComponent(hyf.divider.widthAdjustTarget);
            hyf.divider.currentWidth = -1;
        }

        if (hyf.divider.moveDivider != null)
        {
            hyf.divider.moveDivider.style.display = 'none';
        }
    }
}

hyf.divider.dividerDoubleClicked = function(target)
{
    hyf.util.toggleComponent(target);
}


hyf.attachEventHandler(document, 'mousemove', hyf.divider.dividerMove);
hyf.attachEventHandler(document, 'mouseup', hyf.divider.dividerReleased);