/* ===================================================================================================
* WARNING – This file is part of the base implementation for WebMaker, so it should not be edited or changed for any project. 
* These files are replaced if a project is re-imported to the WebMaker Studio or migrated to a new version of the product. 
* For guidance on ‘How do I override or clone Hyfinity webapp files such as CSS & javascript?’, please read the following relevant FAQ entry: 
* http://www.hyfinity.net/faq/index.php?solution_id=1113
==================================================================================================== */

/*
 * collapsiblecontent.js
 *
 * Functions for the collapsible content pallete section 
 *
 * Company: Hyfinity Ltd
 * Copyright (c) 2010
 */

hyf.collapsiblecontent = {}; 

/*
This function is called when the page loads to ensure that any collapsible sections are presented visible or hidden as appropriate. Each collapsible secition has an anchor that has a class that controls the visibility of two groups. The collapsed group is an optional group that may not be used.
*/ 
hyf.collapsiblecontent.init = function()
{ 
dojo.query('.collapsibleSection A.toggleHidden').forEach(function(objDisplayState) { 
        /* Add a span for the anchor that defines the current state and give it a a label defined as a custom attribute */ 
        dojo.query('span',objDisplayState)[0].innerHTML = "<span class='showHideContainer'>" + objDisplayState.getAttribute('showLabel') + " </span>" +     
            dojo.query('span',objDisplayState)[0].innerHTML;     
        /* Ensure all collapsible sections are prepared */
        var objParentNode = objDisplayState;
        while ((objParentNode !=null) && (!dojo.hasClass(objParentNode, 'collapsibleSection')))   
        { 
            objParentNode = objParentNode.parentNode 
        };   
        if (objParentNode != null)  
        { 
            dojo.query('> .collapsibleContent, > .collapsedContent', objParentNode).toggleClass('hide');  
         } 
    } ); 

    dojo.query('.collapsibleSection A.toggleVisible').forEach(function(objDisplayState) { 
        dojo.query('span',objDisplayState)[0].innerHTML = "<span class='showHideContainer'>" + 
            objDisplayState.getAttribute('hideLabel') + " </span>" +
            dojo.query('span',objDisplayState)[0].innerHTML;    
    } ); 
}
/* This function is called for the toggling anchor to change the visibility state of the groups */
hyf.collapsiblecontent.toggle = function(toggleAnchor)
{ 
    var currentState = (dojo.hasClass(toggleAnchor, 'toggleHidden')) ? 'Hidden' : 'Visible';  
    var displayText = dojo.query('.showHideContainer', toggleAnchor)[0];     
    if (currentState == 'Visible')   
    {     
        displayText.innerHTML = toggleAnchor.getAttribute('showLabel') + " ";
    }
    else  
    {   
       displayText.innerHTML = toggleAnchor.getAttribute('hideLabel') + " ";
    };
    dojo.toggleClass(toggleAnchor, 'toggleVisible');
    dojo.toggleClass(toggleAnchor, 'toggleHidden');
    
    var objParentNode = toggleAnchor;
    while ((objParentNode !=null) && (!dojo.hasClass(objParentNode, 'collapsibleSection')))   
        { 
            objParentNode = objParentNode.parentNode 
        };   
        if (objParentNode != null)  
        { 
            dojo.query('> .collapsibleContent, > .collapsedContent', objParentNode).forEach(function(group)
            {
                    hyf.util.toggleComponent(group, null, true);
            } );  
         } 
}

dojo.addOnLoad(hyf.collapsiblecontent.init)