<?xml version="1.0" encoding="UTF-8"?>
<!--
/* ===================================================================================================
* WARNING – This file is part of the base implementation for WebMaker, so it should not be edited or changed for any project. 
* These files are replaced if a project is re-imported to the WebMaker Studio or migrated to a new version of the product. 
* For guidance on ‘How do I override or clone Hyfinity webapp files such as CSS & javascript?’, please read the following relevant FAQ entry: 
* http://www.hyfinity.net/faq/index.php?solution_id=1113
==================================================================================================== */
-->
<xsl:stylesheet exclude-result-prefixes="mvc" version="1.0" xmlns:mvc="http://www.hyfinity.com/mvc" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output encoding="ISO-8859-1" indent="yes" method="html" />
    <!--
        Generates the skeleton html for the screen, lays out the tables that make up the page calling appropriate templates to fill in page content.
    -->
    <xsl:template match="/" name="demo_skin">
        <html lang="en" xml:lang="en" xmlns="">
            <head>
<!-- Fill in the contents of the <head> html element -->
                <xsl:call-template name="head_html" />
            </head>
            <xsl:call-template name="body" />
        </html>
    </xsl:template>
    <xsl:template name="body">
        <body class="soria" xmlns="">
            <!-- Main Screen Sections -->

            <!--<xsl:call-template name="tagline" />-->

            <!-- Fill in the main body -->
            <xsl:call-template name="main_body" />

            <!-- create the hidden div to use for popup messages -->
            <div id="tipDiv" style="position:absolute; top:-100px; left:-300px; width : 300px; height : 100px; visibility:hidden;">
                <iframe id="tipFrame" name="tipFrame" src="about:blank" style="width :300px; height : 100px;" title="tipFrame">
                    <xsl:text> </xsl:text>
                </iframe>
                <div id="messageDiv" style="position: absolute; top : 0 ; left : 0; width : 100%; height : auto;">
                    <xsl:text> </xsl:text>
                </div>
            </div>
        </body>
    </xsl:template>
<!--
        Provides the contents for the HTML <head> element
    -->
    <xsl:template name="head_html">
        <title xmlns="">BizFlow WebMaker</title>
        <!-- insert css -->
        <xsl:call-template name="css_imports" />
        <xsl:call-template name="global_css_imports" />
        <!-- insert application wide meta tags.
             This template is implemented below -->
        <xsl:call-template name="global_meta_tags" />
        <!-- insert page meta tags.
             This template needs to be implemented by each page that requires custom scripts -->
        <xsl:call-template name="page_meta_tags" />
        <!-- Fill in the client side scripts -->
        <xsl:call-template name="global_scripts" />
        <xsl:call-template name="page_scripts" />
    </xsl:template>
    <!--
        Contains CSS files that are needed for evey page, in addiotn to the settings within FormMaker.
        This currently contains the dojo required files.
    -->
    <xsl:template name="global_css_imports">
        <link href="js/dojo/dojo/resources/dojo.css" rel="stylesheet" type="text/css" xmlns="" />
        <!--<link href="js/dojo/dijit/themes/tundra/tundra.css" rel="stylesheet" type="text/css" xmlns="" />-->
        <link href="js/dojo/dijit/themes/soria/soria.css" rel="stylesheet" type="text/css" xmlns="" />
    </xsl:template>
    <!--
        Placeholder for specifying application specific CSS files.
        This template will be overridden by each page to specify the required CSS imports using the
        information defined within FormMaker.
    -->
    <xsl:template name="css_imports"></xsl:template>
    <!-- Contains all the META tags that should be placed on every page of the application. -->
    <xsl:template name="global_meta_tags">
        <meta content="text/xml; charset=UTF-8" http-equiv="Content-Type" xmlns="" />
        <meta content="text/css" http-equiv="Content-Style-Type" xmlns="" />
        <meta content="index,follow" http-equiv="Robots" name="Robots" xmlns="" />
        <meta content="noarchive" name="robots" xmlns="" />
        <meta content="true" name="MSSmartTagsPreventParsing" xmlns="" />
        <meta content="no" name="publication" xmlns="" />
        <!--<meta content="http://localhost:7080/Example" name="DC.identifier" scheme="URI" xmlns="" />
        <meta content="Hyfinity Corporate Web Site" lang="en" name="DC.title" xmlns="" />
        <meta content="FormMaker by Hyfinity Limited" lang="en" name="DC.creator" xmlns="" />
        <meta content="Hyfinity MVC demonstration application" name="DC.description" xmlns="" />
        <meta content="FormMaker by Hyfinity Limited - info@hyfinity.com" lang="en" name="DC.publisher" xmlns="" />
        <meta content="2005-03-14" name="DC.date.created" scheme="W3CDTF" xmlns="" />
        <meta content="2005-03-14" name="DC.date.modified" scheme="W3CDTF" xmlns="" />
        <meta content="text/html" name="DC.format" scheme="IMT" xmlns="" />
        <meta content="FormMaker by Hyfinity Limited" name="DC.contributor" xmlns="" />
        <meta content="Hyfinity Limited - http://www.hyfinity.com" name="DC.rights.copyright" xmlns="" />
        <meta content="FormMaker by Hyfinity Limited" http-equiv="Author" name="Author" xmlns="" />
        <meta content="XML, SOA, Service Oriented Architecture, composite applications, xforms, xsd, transactional web sites, B2B integration" name="keywords" xmlns="" />
        <meta content="Hyfinity MVC demonstration application" name="description" xmlns="" />-->
    </xsl:template>
    <!-- Details all the page specific meta tags required.
         This template should be overridden by each page that requires custom meta tags. -->
    <xsl:template name="page_meta_tags" />
    <!-- Import the standard scripts required on every FormMaker page
         If you wish to add any additional script files to your particular project, this should be
         done using the options on the FormMaker Application Map screen. -->
    <xsl:template name="global_scripts">
        <script type="text/javascript" xmlns="">
            djConfig={parseOnLoad: true};
        </script>
        <script src="js/dojo/dojo/dojo.js" type="text/javascript" xmlns="">//import dojo main script</script>
        <script src="js/DisplayUtils.js" type="text/javascript" xmlns="">//handles hide/display operations</script>
        <script src="js/FormValidator.js" type="text/javascript" xmlns="">//main entry point for validating a form</script>
        <script src="js/NumberValidator.js" type="text/javascript" xmlns="">//provides number validation</script>
        <script src="js/StringValidator.js" type="text/javascript" xmlns="">//provides string validation</script>
        <script src="js/BooleanValidator.js" type="text/javascript" xmlns="">//provides boolean validation</script>
        <script src="js/ValidationError.js" type="text/javascript" xmlns="">//represents a valiadtion error</script>
        <script src="js/ErrorDisplay.js" type="text/javascript" xmlns="">//shows validation errors on the form </script>
        <script src="js/DisplayMessages.js" type="text/javascript" xmlns="">//provides a list of display messages for each error</script>
        <script src="js/DateValidator.js" type="text/javascript" xmlns="">//provides date validation functions</script>
        <script src="js/FMActions.js" type="text/javascript" xmlns="">//provides implementations of the FM inbuilt actions</script>
        <script src="js/ValueConverter.js" type="text/javascript" xmlns="">//provides value conversion functions</script>
        <script src="js/combobox.js" type="text/javascript" xmlns="">//script required for editable combo box entries</script>
        <script src="js/date.js" type="text/javascript" xmlns="">//provides date manipulation functions</script>
        <script src="js/AnchorPosition.js" type="text/javascript" xmlns="">//determines the coordinates of an anchor</script>
        <script src="js/PopupWindow.js" type="text/javascript" xmlns="">//shows a popup window</script>
        <script src="js/CalendarPopup.js" type="text/javascript" xmlns="">//creates a calendar popup - needs the above two</script>
        <script src="js/basicwihactionclient.js" type="text/javascript" xmlns="">//Work Item Handler client</script>
    </xsl:template>
    <!--
        Place holder for page specific script includes.
        This will be overridden by each page XSL to include the files specified within FormMaker
    -->
    <xsl:template name="page_scripts" />

    <xsl:template name="tagline">
        <div class="tagline">
            <div class="l">
                <div class="r">
                    <!-- Create the logo -->
                    <xsl:call-template name="logo" />
                </div>
            </div>
        </div>

    </xsl:template>

    <!--
        Create the logo that is present on every screen
    -->
    <xsl:template name="logo">

    </xsl:template>

    <!--
        Builds the main body of the page adding a header, footer and content area.
    -->
    <xsl:template name="main_body">
        <!-- Fill in the main body -->
        <div class="main_body" xmlns="">
            <xsl:if test="/mvc:eForm/mvc:Control/error">
                <div class="messageBox">
                    <xsl:for-each select="/mvc:eForm/mvc:Control/error">
                        <xsl:value-of select="./@desc" />
                        <br />
                    </xsl:for-each>
                </div>
            </xsl:if>
            <xsl:call-template name="section_body" />
            <!--Fill in the contents of the page footer -->
            <xsl:call-template name="footer" />


            <xsl:call-template name="output-test-mode-buttons" />
        </div>
    </xsl:template>

    <!--
        Builds the section body within main body.
        This template will be overridden by each page to supply the main content
    -->
    <xsl:template name="section_body" />
    <!--
        Provides HTML content for the footer.
    -->
    <xsl:template name="footer">
    </xsl:template>

    <!-- Work out whether the page is being displayed in test mode,
         and if so output buttons to allow testing of the Workitem Handler interface points.
         This currently only supports the save, complete and exit buttons. -->
    <xsl:template name="output-test-mode-buttons">
        <xsl:if test="/mvc:eForm/mvc:Data/WorkitemContext/TestMode = 'IsolatedForm'">
            <!--shoud output the buttons -->
            <div id="workitem_test_buttons">
                <button id="onWorkitemSave_test_button" onclick="onWorkitemSave()">Save</button>
                <button id="onWorkitemComplete_test_button" onclick="onWorkitemComplete()">Complete</button>
                <button id="onWorkitemExit_test_button" onclick="onWorkitemExit()">Exit</button>
                <script type="text/javascript">
                    hyf.attachEventHandler(window, 'onload', function(){
                        if (typeof(window.onWorkitemSave) != 'function')
                            document.getElementById('onWorkitemSave_test_button').style.display = 'none';
                        if (typeof(window.onWorkitemComplete) != 'function')
                            document.getElementById('onWorkitemComplete_test_button').style.display = 'none';
                        if (typeof(window.onWorkitemExit) != 'function')
                            document.getElementById('onWorkitemExit_test_button').style.display = 'none';
                        });
                </script>
            </div>
        </xsl:if>
    </xsl:template>


</xsl:stylesheet>
